/*
 * Decompiled with CFR 0.152.
 */
package ags.disk;

import ags.disk.RWTS;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class Disk {
    public static final int TRACK_COUNT = 35;
    public static final int SECTOR_COUNT = 16;
    byte[][][] diskImage = new byte[35][16][256];
    private List<RWTS> rwts = new ArrayList<RWTS>();
    int VOLUME_NUMBER = 254;
    int[] NIBBLE_62 = new int[]{150, 151, 154, 155, 157, 158, 159, 166, 167, 171, 172, 173, 174, 175, 178, 179, 180, 181, 182, 183, 185, 186, 187, 188, 189, 190, 191, 203, 205, 206, 207, 211, 214, 215, 217, 218, 219, 220, 221, 222, 223, 229, 230, 231, 233, 234, 235, 236, 237, 238, 239, 242, 243, 244, 245, 246, 247, 249, 250, 251, 252, 253, 254, 255};

    public Disk(InputStream file) throws IOException {
        this.openDiskImage(file);
    }

    public Disk(String filename) throws IOException {
        File f = new File(filename);
        if (f.exists()) {
            this.openDiskImage(new FileInputStream(f));
        } else {
            InputStream i = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
            if (i != null) {
                this.openDiskImage(i);
            } else {
                i = ClassLoader.getSystemResourceAsStream(filename);
                if (i != null) {
                    this.openDiskImage(i);
                } else {
                    System.out.println("Could not find file " + filename);
                }
            }
        }
    }

    public void registerRWTS(RWTS r) {
        this.rwts.add(r);
        r.disk = this;
    }

    public RWTS.CommandBlock parseCommand(byte[] data) {
        for (RWTS r : this.rwts) {
            RWTS.CommandBlock c = r.parseCommandBlock(data);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private void openDiskImage(InputStream file) throws IOException {
        int counter = 0;
        while (file.available() > 0) {
            byte[] sector = new byte[256];
            int read = file.read(sector);
            if (read < 256) {
                System.out.println("Read less than 256 bytes for last sector! (got " + read + " instead)");
            }
            int sectorNumber = counter % 16;
            int trackNumber = counter / 16;
            this.setSector(trackNumber, sectorNumber, sector);
            ++counter;
        }
    }

    protected abstract int translatePhysicalSectorNumber(int var1);

    protected abstract int translateLogicalSectorNumber(int var1);

    protected byte[] getRWTSReplacement(byte[] sector, int target) {
        for (RWTS r : this.rwts) {
            if (!r.matches(sector)) continue;
            return r.getReloactedRWTS(target, sector);
        }
        return sector;
    }

    public byte[] getSector(int trackNumber, int sectorNumber, int target) {
        byte[] sector = this.diskImage[trackNumber][sectorNumber];
        sector = this.getRWTSReplacement(sector, target);
        return sector;
    }

    public void setSector(int trackNumber, int sectorNumber, byte[] sector) {
        this.diskImage[trackNumber][sectorNumber] = sector;
    }

    public byte[] getNybblizedSector(int track, int sector) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.writeJunkBytes(output, 15);
        this.writeAddressBlock(output, track, sector);
        this.writeJunkBytes(output, 4);
        this.writeDataBlock(output, track, sector, this.getSector(track, sector, 0));
        this.writeJunkBytes(output, 34);
        return output.toByteArray();
    }

    private void writeJunkBytes(ByteArrayOutputStream output, int i) {
        for (int b = 0; b < i; ++b) {
            output.write(255);
        }
    }

    private void writeAddressBlock(ByteArrayOutputStream output, int track, int sector) throws IOException {
        output.write(213);
        output.write(170);
        output.write(150);
        int checksum = 0;
        checksum ^= this.VOLUME_NUMBER;
        output.write(this.getOddEven(this.VOLUME_NUMBER));
        checksum ^= track;
        output.write(this.getOddEven(track));
        output.write(this.getOddEven(sector));
        output.write(this.getOddEven((checksum ^= sector) & 0xFF));
        output.write(222);
        output.write(170);
        output.write(235);
    }

    private byte[] getOddEven(int i) {
        byte[] out = new byte[]{(byte)(0xAA | i >> 1), (byte)(0xAA | i)};
        return out;
    }

    private void writeDataBlock(ByteArrayOutputStream output, int track, int sector, byte[] nibbles) {
        int value;
        int i;
        int[] temp = new int[342];
        for (int i2 = 0; i2 < 256; ++i2) {
            temp[i2] = (nibbles[i2] & 0xFF) >> 2;
        }
        int hi = 1;
        int med = 171;
        int low = 85;
        for (int i3 = 0; i3 < 86; ++i3) {
            int value2;
            temp[i3 + 256] = value2 = (nibbles[hi] & 1) << 5 | (nibbles[hi] & 2) << 3 | (nibbles[med] & 1) << 3 | (nibbles[med] & 2) << 1 | (nibbles[low] & 1) << 1 | (nibbles[low] & 2) >> 1;
            hi = hi - 1 & 0xFF;
            med = med - 1 & 0xFF;
            low = low - 1 & 0xFF;
        }
        output.write(213);
        output.write(170);
        output.write(173);
        int last = 0;
        for (i = temp.length - 1; i > 255; --i) {
            value = temp[i] ^ last;
            output.write(this.NIBBLE_62[value]);
            last = temp[i];
        }
        for (i = 0; i < 256; ++i) {
            value = temp[i] ^ last;
            output.write(this.NIBBLE_62[value]);
            last = temp[i];
        }
        output.write(this.NIBBLE_62[last]);
        output.write(222);
        output.write(170);
        output.write(235);
    }
}

